/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

final class ResourceUtil {
    ResourceUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon loadImageIconFromResources(String string) {
        if (string == null || string.trim().isEmpty()) {
            System.err.println("Error: Resource path cannot be null or empty.");
            return null;
        }
        try (InputStream inputStream = ResourceUtil.class.getResourceAsStream(string);){
            if (inputStream == null) {
                System.err.println("Error: Resource not found at path: " + string);
                System.err.println("Ensure the path starts with '/' and is correct relative to the JAR root.");
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                System.err.println("Error: Could not decode image at path: " + string);
                System.err.println("Ensure the file is a valid image format (PNG, JPG, GIF).");
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            return imageIcon;
        }
        catch (IOException iOException) {
            System.err.println("Error loading image resource: " + string);
            iOException.printStackTrace();
            return null;
        }
    }
}

