/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class Player
extends Thing {
    GamePanel gp;
    InputController keys;
    ImageIcon im;
    Color scoopColor;
    Toolkit tk;
    CursorType cType;
    public boolean clicking = false;
    public boolean checking = false;
    public boolean trashing = false;
    public boolean playing = false;
    public boolean exiting = false;
    public boolean learning = false;
    public boolean retrying = false;
    public boolean isColliding = false;
    public boolean isRetrying = false;
    public boolean isLearning = false;
    public boolean isTrashing = false;
    public boolean isChecking = false;
    public boolean isPlaying = false;
    public boolean isExiting = false;

    public Player(GamePanel gamePanel, InputController inputController, ImageIcon imageIcon) {
        this.gp = gamePanel;
        this.keys = inputController;
        this.im = imageIcon;
        this.cType = CursorType.KEYS;
        this.spawn();
    }

    public void spawn() {
        this.x = this.gp.tileSize * 8;
        this.y = this.gp.tileSize * 8;
        this.speed = 5;
    }

    public void update() {
        switch (this.cType) {
            case KEYS: {
                if (this.keys.downPressed) {
                    this.y += this.speed;
                }
                if (this.keys.upPressed) {
                    this.y -= this.speed;
                }
                if (this.keys.rightPressed) {
                    this.x += this.speed;
                }
                if (this.keys.leftPressed) {
                    this.x -= this.speed;
                }
                if (this.keys.clicked && this.isColliding) {
                    this.clicking = true;
                    break;
                }
                if (this.keys.clicked && this.isTrashing) {
                    this.trashing = true;
                    break;
                }
                if (this.keys.clicked && this.isChecking) {
                    this.checking = true;
                    break;
                }
                if (this.keys.clicked && this.isPlaying) {
                    this.playing = true;
                    break;
                }
                if (this.keys.clicked && this.isLearning) {
                    this.learning = true;
                    break;
                }
                if (this.keys.clicked && this.isExiting) {
                    this.exiting = true;
                    break;
                }
                if (this.keys.clicked && this.isRetrying) {
                    this.retrying = true;
                    break;
                }
                this.playing = false;
                this.checking = false;
                this.trashing = false;
                this.clicking = false;
                this.exiting = false;
                this.learning = false;
                this.retrying = false;
                break;
            }
        }
    }

    public void switchCursors() {
        if (this.cType == CursorType.KEYS) {
            this.tk = Toolkit.getDefaultToolkit();
            Cursor cursor = this.tk.createCustomCursor(this.im.getImage(), new Point(0, 0), "");
            this.gp.setCursor(cursor);
            this.cType = CursorType.MOUSE;
        }
    }

    public void toKeys() {
        this.cType = CursorType.KEYS;
        this.gp.setCursor(Cursor.getDefaultCursor());
    }

    public void draw(Graphics graphics) {
        this.im.paintIcon(this.gp, graphics, this.x, this.y);
    }

    public void detectCollision(Button button, Button button2, Button button3) {
        if (this.x - button.x >= 0 && this.x - button.x <= 50 && this.y - button.y >= 0 && this.y - button.y <= 50 && !this.keys.clicked) {
            this.isColliding = true;
            this.scoopColor = button.c;
        } else if (this.x - button2.x >= 0 && this.x - button2.x <= 50 && this.y - button2.y >= 0 && this.y - button2.y <= 50 && !this.keys.clicked) {
            this.isColliding = true;
            this.scoopColor = button2.c;
        } else if (this.x - button3.x >= 0 && this.x - button3.x <= 50 && this.y - button3.y >= 0 && this.y - button3.y <= 50 && !this.keys.clicked) {
            this.isColliding = true;
            this.scoopColor = button3.c;
        } else {
            this.isColliding = false;
        }
    }

    public void detectTrash(Button button) {
        this.isTrashing = this.x - button.x >= 0 && this.x - button.x <= 50 && this.y - button.y >= 0 && this.y - button.y <= 50 && !this.keys.clicked;
    }

    public void detectRetry(Button button) {
        if (this.x - button.x >= 0 && this.x - button.x <= 40 && this.y - button.y >= 0 && this.y - button.y <= 40 && !this.keys.clicked) {
            this.isRetrying = true;
            button.im = button.litIm;
        } else {
            this.isRetrying = false;
            button.im = button.unlitIm;
        }
    }

    public void detectCheck(Button button) {
        this.isChecking = this.x - button.x >= 0 && this.x - button.x <= 50 && this.y - button.y >= 0 && this.y - button.y <= 50 && !this.keys.clicked;
    }

    public void detectPlay(Button button) {
        if (this.x - button.x >= 0 && this.x - button.x <= 40 && this.y - button.y >= 0 && this.y - button.y <= 40 && !this.keys.clicked) {
            this.isPlaying = true;
            button.im = button.litIm;
        } else {
            this.isPlaying = false;
            button.im = button.unlitIm;
        }
    }

    public void detectExit(Button button) {
        if (this.x - button.x >= 0 && this.x - button.x <= 40 && this.y - button.y >= 0 && this.y - button.y <= 40 && !this.keys.clicked || button.isClicked) {
            this.isExiting = true;
            button.im = button.litIm;
        } else {
            this.isExiting = false;
            button.im = button.unlitIm;
        }
    }

    public void detectInfo(Button button) {
        if (this.x - button.x >= 0 && this.x - button.x <= 40 && this.y - button.y >= 0 && this.y - button.y <= 40 && !this.keys.clicked || button.isClicked) {
            this.isLearning = true;
            button.im = button.litIm;
        } else {
            this.isLearning = false;
            button.im = button.unlitIm;
        }
    }

    static enum CursorType {
        MOUSE,
        KEYS;

    }
}

