/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import javax.swing.ImageIcon;

public class Kid
extends Thing {
    GamePanel gp;
    Sprite spr;
    ImageIcon kid1;
    ImageIcon kid2;
    ImageIcon kid3;
    ImageIcon kid1S;
    ImageIcon kid2S;
    ImageIcon kid3S;
    ImageIcon kid1H;
    ImageIcon kid2H;
    ImageIcon kid3H;
    Status stat;
    Color[] order;
    int orderSize;
    int initX;
    int initY;
    Random r;
    public boolean isPrinting = false;
    public int count = 0;
    public int interval = 60;

    public Kid(GamePanel gamePanel, int n, int n2, int n3) {
        this.gp = gamePanel;
        this.x = n * this.gp.tileSize;
        this.initX = n * this.gp.tileSize;
        this.y = n2 * this.gp.tileSize;
        this.initY = n2 * this.gp.tileSize;
        this.speed = 2;
        this.stat = Status.GREETING;
        this.loadSprites();
        if (n3 == 0) {
            this.spr = new Sprite(this.gp, this.kid1, this.x, this.y);
        }
        if (n3 == 1) {
            this.spr = new Sprite(this.gp, this.kid2, this.x, this.y);
        }
        if (n3 == 2) {
            this.spr = new Sprite(this.gp, this.kid3, this.x, this.y);
        }
        this.order = new Color[0];
    }

    public void update() {
        switch (this.stat) {
            case GREETING: {
                this.greet(6.98f);
                break;
            }
            case ORDERING: {
                this.makeDecision();
                this.isPrinting = true;
                this.stat = Status.WAITING;
                break;
            }
            case WAITING: {
                break;
            }
            case APPROVED: {
                this.isPrinting = false;
                if (this.spr.icon == this.kid1) {
                    this.spr.icon = this.kid1H;
                }
                if (this.spr.icon == this.kid2) {
                    this.spr.icon = this.kid2H;
                }
                if (this.spr.icon == this.kid3) {
                    this.spr.icon = this.kid3H;
                }
                this.sayBye();
                break;
            }
            case DENIED: {
                this.isPrinting = false;
                this.sayBye();
                break;
            }
            case DEAD: {
                this.resetKid();
                break;
            }
        }
    }

    public void makeDecision() {
        this.r = new Random();
        this.orderSize = this.r.nextInt(6);
        if (this.orderSize <= 1) {
            this.orderSize += 2;
        }
        this.order = new Color[this.orderSize];
        block5: for (int i = 0; i < this.orderSize; ++i) {
            int n = this.r.nextInt(3);
            switch (n) {
                case 0: {
                    this.order[i] = Color.RED;
                    continue block5;
                }
                case 1: {
                    this.order[i] = Color.YELLOW;
                    continue block5;
                }
                case 2: {
                    this.order[i] = Color.BLUE;
                    continue block5;
                }
            }
        }
    }

    public void printDecision() {
        for (int i = 0; i < this.orderSize; ++i) {
            if (this.order[i] == Color.BLUE) {
                System.out.println("Blue scoop");
            }
            if (this.order[i] == Color.YELLOW) {
                System.out.println("Yellow scoop");
            }
            if (this.order[i] != Color.RED) continue;
            System.out.println("Red scoop");
        }
    }

    public void resetKid() {
        this.x = this.initX;
        this.y = this.initY;
        this.r = new Random();
        int n = this.r.nextInt(3);
        switch (n) {
            case 0: {
                this.spr = new Sprite(this.gp, this.kid1, this.x, this.y);
                break;
            }
            case 1: {
                this.spr = new Sprite(this.gp, this.kid2, this.x, this.y);
                break;
            }
            case 2: {
                this.spr = new Sprite(this.gp, this.kid3, this.x, this.y);
            }
        }
        this.stat = Status.GREETING;
    }

    public void greet(float f) {
        float f2 = this.x;
        Objects.requireNonNull(this.gp);
        if (f2 <= 48.0f * f) {
            this.spr.x += this.speed;
            this.x += this.speed;
        } else {
            this.stat = Status.ORDERING;
        }
    }

    public void detectTimer(Timer timer) {
        if (timer.labelText == 0 && this.stat == Status.WAITING) {
            if (this.spr.icon == this.kid1) {
                this.spr.icon = this.kid1S;
            }
            if (this.spr.icon == this.kid2) {
                this.spr.icon = this.kid2S;
            }
            if (this.spr.icon == this.kid3) {
                this.spr.icon = this.kid3S;
            }
            this.stat = Status.DENIED;
            this.sayBye();
        }
    }

    public void sayBye() {
        if (this.x <= this.gp.screenWidth) {
            this.spr.x += this.speed;
            this.x += this.speed;
        } else {
            this.stat = Status.DEAD;
        }
    }

    public void draw(Graphics graphics) {
        this.spr.draw(graphics);
    }

    public void loadSprites() {
        this.kid1 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid1.png");
        this.kid1S = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid1S.png");
        this.kid1H = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid1H.png");
        this.kid2 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid2.png");
        this.kid2S = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid2S.png");
        this.kid2H = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid2H.png");
        this.kid3 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid3.png");
        this.kid3S = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid3S.png");
        this.kid3H = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/kid3H.png");
    }

    public boolean isOK(ArrayList<Scoop> arrayList, Color[] colorArray) {
        if (arrayList.size() == 0 || colorArray.length == 0) {
            System.out.println("Wrong");
            return false;
        }
        for (int i = 0; i < colorArray.length; ++i) {
            if (arrayList.size() != colorArray.length) {
                System.out.println("Wrong");
                return false;
            }
            if (arrayList.get((int)i).c == colorArray[i]) continue;
            System.out.println("Wrong");
            return false;
        }
        return true;
    }

    public boolean isOrdering() {
        return this.stat == Status.ORDERING;
    }

    public void drawOrder(Graphics graphics) {
        int n = this.x + 64;
        int n2 = 0;
        graphics.setColor(Color.DARK_GRAY);
        graphics.fillOval(n - 3, this.y + 55, 31, 31);
        graphics.setColor(this.order[n2]);
        graphics.fillOval(n, this.y + 58, 25, 25);
        n += 48;
        ++n2;
        while (n2 < this.orderSize) {
            if (this.count < this.interval) {
                ++this.count;
                continue;
            }
            this.count = 0;
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillOval(n - 3, this.y + 55, 31, 31);
            graphics.setColor(this.order[n2]);
            graphics.fillOval(n, this.y + 58, 25, 25);
            n += 48;
            ++n2;
        }
    }

    public static enum Status {
        GREETING,
        ORDERING,
        WAITING,
        APPROVED,
        DENIED,
        DEAD;

    }
}

