/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable {
    final int pixelSize = 16;
    final int scale = 3;
    final int tileSize = 48;
    final int maxVSize = 10;
    final int maxHSize = 15;
    final int screenHeight = 480;
    final int screenWidth = 720;
    int FPS = 60;
    InputController keys = new InputController();
    Thread gameThread;
    ImageIcon cursor = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/Ice Cream-2.png");
    ImageIcon button1 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/sprite_02.png");
    ImageIcon button2 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/sprite_03.png");
    ImageIcon button3 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/sprite_04.png");
    ImageIcon button4 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/sprite_32.png");
    ImageIcon button5 = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/check.png");
    ImageIcon title = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/logo.png");
    ImageIcon playB = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/play.png");
    ImageIcon playBLit = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/playLit.png");
    ImageIcon info = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/instructions.png");
    ImageIcon infoLit = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/instructionsLit.png");
    ImageIcon retry = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/retry.png");
    ImageIcon retryLit = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/retryLit.png");
    ImageIcon exit = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/exit.png");
    ImageIcon exitLit = ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/exitLit.png");
    Sprite tS = new Sprite(this, this.title, 202, 96);
    Button b1 = new Button(this, this.button2, Color.BLUE, 5, 8);
    Button b2 = new Button(this, this.button1, Color.RED, 7, 8);
    Button b3 = new Button(this, this.button3, Color.YELLOW, 9, 8);
    Button clear = new Button(this, this.button4, Color.RED, 11, 8);
    Button check = new Button(this, this.button5, Color.RED, 3, 8);
    Button play = new Button(this, this.playB, this.playBLit, Color.BLUE, 7, 7);
    Button infoB = new Button(this, this.info, this.infoLit, Color.BLUE, 9, 7);
    Button retryB = new Button(this, this.retry, this.retryLit, Color.BLUE, 7, 7);
    Button exitB = new Button(this, this.exit, this.exitLit, Color.BLUE, 5, 7);
    Player player = new Player(this, this.keys, this.cursor);
    SpriteMap spriteMap = new SpriteMap(this);
    IceCream ice = new IceCream(this, ResourceUtil.loadImageIconFromResources("/resources/Ice Cream/sprite_05.png"), 336, 240);
    Random r = new Random();
    Cloud cloud1 = new Cloud(this, 1, 5, 1, this.r.nextInt(3));
    Cloud cloud2 = new Cloud(this, 2, 0, 1, this.r.nextInt(3));
    Cloud cloud3 = new Cloud(this, 2, 12, 1, this.r.nextInt(3));
    Cloud cloud4 = new Cloud(this, 1, 8, 1, this.r.nextInt(3));
    Cloud cloud5 = new Cloud(this, 1, 6, 1, this.r.nextInt(3));
    Cloud c1 = new Cloud(this, 1, 5, 1, this.r.nextInt(9));
    Cloud c2 = new Cloud(this, 2, 0, 1, this.r.nextInt(9));
    Cloud c3 = new Cloud(this, 2, 12, 1, this.r.nextInt(9));
    Cloud c4 = new Cloud(this, 3, 8, 1, this.r.nextInt(9));
    Cloud c5 = new Cloud(this, 4, 9, 1, this.r.nextInt(9));
    Cloud bird = new Cloud(this, 4, 9, 1, 2);
    Kid kid = new Kid(this, 0, 4, this.r.nextInt(3));
    Timer t = new Timer(this, false, 1, 7, 7, 11);
    Timer t0 = new Timer(this, true, 0, 13, 1, 60);
    Score s = new Score(this, 75, 1);
    Score fScore;
    Score hScore;
    InfoPanel ip = new InfoPanel(this, 2, 1);
    GameState state = GameState.START;
    public Color bgC = new Color(24, 164, 232);
    boolean saving = true;

    public GamePanel() {
        this.setPreferredSize(new Dimension(720, 480));
        this.setBackground(this.bgC);
        this.addKeyListener(this.keys);
        this.setFocusable(true);
    }

    public void StartGameThread() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    @Override
    public void run() {
        double d = 1000000000 / this.FPS;
        double d2 = (double)System.nanoTime() + d;
        while (this.gameThread != null) {
            this.update();
            this.repaint();
            try {
                double d3 = d2 - (double)System.nanoTime();
                d3 /= 1000000.0;
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                Thread.sleep((long)d3);
                d2 += d;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void update() {
        this.player.update();
        switch (this.state) {
            case START: {
                this.setBackground(this.bgC);
                this.c1.move(1);
                this.c2.move(1);
                this.c3.move(1);
                this.c4.move(1);
                this.c5.move(1);
                this.player.detectPlay(this.play);
                this.player.detectInfo(this.infoB);
                this.player.detectExit(this.exitB);
                if (this.player.learning) {
                    this.ip.toggle();
                }
                if (this.player.playing) {
                    this.state = GameState.PLAYING;
                }
                if (this.player.exiting) {
                    System.exit(0);
                }
                this.s.pScore = 0;
                break;
            }
            case PLAYING: {
                this.setBackground(this.bgC);
                this.player.detectCollision(this.b1, this.b2, this.b3);
                if (this.player.clicking) {
                    this.ice.addScoop(this.player.scoopColor);
                }
                this.ice.update();
                this.player.detectTrash(this.clear);
                if (this.player.trashing) {
                    this.ice.clear();
                }
                this.kid.update();
                if (this.kid.isOrdering()) {
                    this.s.isListening = true;
                    this.t.reset();
                }
                if (this.kid.stat == Kid.Status.WAITING) {
                    this.t.isOn = true;
                }
                if (this.t.isOn && this.kid.stat == Kid.Status.WAITING) {
                    this.t.updateT1();
                }
                this.kid.detectTimer(this.t);
                this.s.checkScore(this.t, this.kid);
                this.player.detectCheck(this.check);
                if (this.player.checking) {
                    if (this.kid.isOK(this.ice.scoops, this.kid.order) && this.kid.stat == Kid.Status.WAITING) {
                        System.out.println("Correct");
                        this.kid.stat = Kid.Status.APPROVED;
                        this.t.isOn = false;
                        this.t.isUpdating = false;
                        this.ice.clear();
                        this.s.isListening = true;
                    } else {
                        System.out.println("Incorrect");
                    }
                }
                this.s.checkScore(this.t, this.kid);
                this.cloud1.move(0);
                this.cloud2.move(0);
                this.cloud3.move(0);
                this.cloud4.move(0);
                this.cloud5.move(0);
                this.bird.move(0);
                this.t0.updateT1();
                if (this.t0.labelText != 0) break;
                if (this.kid.stat == Kid.Status.APPROVED || this.kid.stat == Kid.Status.DENIED) {
                    this.state = GameState.END;
                }
                if (this.t.labelText != 0) break;
                this.state = GameState.END;
                break;
            }
            case END: {
                this.t0.labelText = 60;
                this.setBackground(Color.LIGHT_GRAY);
                this.player.detectRetry(this.retryB);
                this.player.detectExit(this.exitB);
                if (this.player.exiting) {
                    System.exit(0);
                }
                if (!this.player.retrying) break;
                this.state = GameState.START;
                break;
            }
            default: {
                this.setBackground(Color.LIGHT_GRAY);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (this.state) {
            case START: {
                this.spriteMap.drawStart(graphics);
                this.c1.draw(graphics);
                this.c2.draw(graphics);
                this.tS.draw(graphics);
                this.c3.draw(graphics);
                this.c4.draw(graphics);
                this.c5.draw(graphics);
                this.play.draw(graphics);
                this.exitB.draw(graphics);
                this.infoB.draw(graphics);
                this.ip.draw(graphics);
                if (this.player.cType != Player.CursorType.KEYS) break;
                this.player.draw(graphics);
                break;
            }
            case PLAYING: {
                this.kid.draw(graphics);
                this.spriteMap.draw(graphics);
                this.cloud1.draw(graphics);
                this.cloud2.draw(graphics);
                this.cloud3.draw(graphics);
                this.cloud4.draw(graphics);
                this.cloud5.draw(graphics);
                this.bird.draw(graphics);
                this.clear.draw(graphics);
                this.check.draw(graphics);
                this.b1.draw(graphics);
                this.b2.draw(graphics);
                this.b3.draw(graphics);
                if (this.t.isUpdating) {
                    this.t.drawT1(graphics);
                }
                this.s.draw(graphics);
                this.ice.draw(graphics);
                this.player.draw(graphics);
                if (this.kid.isPrinting) {
                    this.kid.drawOrder(graphics);
                }
                if (!this.t0.isUpdating) break;
                this.t0.drawT0(graphics);
                break;
            }
            case END: {
                this.fScore = new Score(this, 7, 5, this.s.pScore);
                this.fScore.drawEndScore(graphics);
                this.retryB.draw(graphics);
                this.exitB.draw(graphics);
                if (this.player.cType != Player.CursorType.KEYS) break;
                this.player.draw(graphics);
                break;
            }
        }
    }
}

