/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AlphaImageIcon
extends ImageIcon {
    private Icon icon;
    private Image image;
    private float alpha;

    public AlphaImageIcon(Icon icon, float f) {
        this.icon = icon;
        this.alpha = f;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setImage(Image image) {
        if (this.icon instanceof ImageIcon) {
            ((ImageIcon)this.icon).setImage(image);
        }
    }

    @Override
    public int getImageLoadStatus() {
        if (this.icon instanceof ImageIcon) {
            return ((ImageIcon)this.icon).getImageLoadStatus();
        }
        return 0;
    }

    @Override
    public ImageObserver getImageObserver() {
        if (this.icon instanceof ImageIcon) {
            return ((ImageIcon)this.icon).getImageObserver();
        }
        return null;
    }

    @Override
    public void setImageObserver(ImageObserver imageObserver) {
        if (this.icon instanceof ImageIcon) {
            ((ImageIcon)this.icon).setImageObserver(imageObserver);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.image = this.icon instanceof ImageIcon ? ((ImageIcon)this.icon).getImage() : null;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.SrcAtop.derive(this.alpha));
        this.icon.paintIcon(component, graphics2D, n, n2);
        graphics2D.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }
}

